## flatpickr - javascript datetime picker
[![Build Status](https://travis-ci.org/chmln/flatpickr.svg?branch=master)](https://travis-ci.org/chmln/flatpickr)
[![Coverage](https://coveralls.io/repos/github/chmln/flatpickr/badge.svg?branch=master)](https://coveralls.io/github/chmln/flatpickr)
[![npm version](https://badge.fury.io/js/flatpickr.svg)](https://www.npmjs.com/package/flatpickr)
![Bower version](https://badge.fury.io/bo/flatpickr-calendar.svg)
[![CDNJS](https://img.shields.io/cdnjs/v/flatpickr.svg)](https://cdnjs.com/libraries/flatpickr)
[![License](https://img.shields.io/badge/license-MIT-blue.svg?style=plastic)](https://raw.githubusercontent.com/chmln/flatpickr/master/LICENSE.md)


![blue](https://cloud.githubusercontent.com/assets/11352152/14549371/3cbb65da-028d-11e6-976d-a6f63f32061f.PNG)
![green](https://cloud.githubusercontent.com/assets/11352152/14549373/3cbe975a-028d-11e6-9192-43975f0146da.PNG)
![confetti](https://cloud.githubusercontent.com/assets/11352152/14549440/de9bf55e-028d-11e6-9271-46782a99efea.PNG)
![red](https://cloud.githubusercontent.com/assets/11352152/14549374/3cc01102-028d-11e6-9ff4-0cf208a310c4.PNG)
![default](https://cloud.githubusercontent.com/assets/11352152/14549370/3cadb750-028d-11e6-818d-c6a1bc6349fc.PNG)
![dark](https://cloud.githubusercontent.com/assets/11352152/14549372/3cbc8514-028d-11e6-8daf-ec1ba01c9d7e.PNG)


## Preamble
Almost every large SPA or project involves date and time input. There are limited options, however, if you also prefer to keep your projects lean and consequently stay away from heavy frameworks such as [jQuery](https://jsperf.com/jquery-vs-javascript-performance-comparison/22), or even Bootstrap.

Appalled at the fact that I have to load 300kb of jquery and jquery UI or hook up bootstrap just to use a calendar, I created this \[date\]\[time\]picker that's powerful, easy to use, and looks good out of the box.

Written in vanilla javascript, works with anything, anywhere.

![wew](https://cloud.githubusercontent.com/assets/11352152/14397836/d02d2f7c-fdad-11e5-9658-bedfb997ff52.png)

## Compatibility
IE9+, iOS Safari 6+, MS Edge, Chrome 8+, Firefox 6+

## Install & Use
CDNJS: https://cdnjs.com/libraries/flatpickr

Demos and documentation: https://chmln.github.io/flatpickr

See also:
* [Vue.js Component](https://github.com/jrainlau/vue-flatpickr)
* [React Component](https://github.com/coderhaoxin/react-flatpickr)
* [ember-flatpickr addon](https://www.npmjs.com/package/ember-flatpickr)
* [angular-flatpickr addon](https://www.npmjs.com/package/angular-flatpickr)

flatpickr out in the wild:
* As a [datepicker in Vue-Blu](https://chenz24.github.io/vue-blu/#/components/datepicker)
